<?php

namespace App\Http\Controllers\Admin;

use Carbon\Carbon;
use App\Models\Cuti;
use App\Models\Absensi;
use App\Models\Karyawan;
use Carbon\CarbonPeriod;
use App\Models\JatahCuti;
use App\Models\Notifikasi;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class AdminCutiController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        // $karyawan = Karyawan::all();
        // $cuti = Cuti::with('karyawan.user')->orderBy('created_at', 'desc')->get();
        // return view('admin.cuti.index', compact('cuti', 'karyawan'));
            $user = Auth::user();

    if ($user->role === 'super_admin') {
        // Super admin lihat semua
        $cuti = Cuti::with('karyawan.departemen')
            ->latest()
            ->get();
    } else {
        // Admin departemen
        $departemenId = $user->karyawan->departemen_id;

        $cuti = Cuti::whereHas('karyawan', function ($q) use ($departemenId) {
                $q->where('departemen_id', $departemenId);
            })
            ->with('karyawan.departemen')
            ->latest()
            ->get();
    }

    return view('admin.cuti.index', compact('cuti'));
    }

    public function approve(Request $request, $id)
    {
        $cuti = Cuti::findOrFail($id);
        $karyawan = $cuti->karyawan;

        DB::transaction(function () use ($cuti, $karyawan) {

            $jumlahHari = Carbon::parse($cuti->tanggal_mulai)->diffInDays(Carbon::parse($cuti->tanggal_selesai)) + 1;
            $jatah = JatahCuti::where('karyawan_id', $karyawan->id)->where('tahun', now()->year)->lockForUpdate()->firstOrFail();

            if ($jatah->jatah < $jumlahHari) {
                return back()->with('error', 'Saldo cuti karyawan tidak mencukupi');
            }

            $jatah->decrement('jatah', $jumlahHari);

            // Update status cuti
            $cuti->update([
                'status' => 'disetujui',
                // 'catatan_admin' => request('catatan_admin'),
            ]);

            Notifikasi::create([
                'user_id' => $cuti->karyawan->user->id,
                'judul' => 'Cuti Disetujui',
                'pesan' => 'Pengajuan cuti Anda telah disetujui.',
                'type' => 'cuti',
                'target_role' => 'karyawan'
            ]);

            if ($jatah->jatah <= 1) {
                Notifikasi::create([
                    'user_id'     => $cuti->karyawan->user->id,
                    'judul'       => 'Sisa Cuti Hampir Habis',
                    'pesan'       => 'Sisa jatah cuti Anda tinggal ' . $jatah->jatah . ' hari.',
                    'type'        => 'cuti',
                    'target_role' => 'karyawan'
                ]);
            }
            // Insert absensi CUTI per hari
            $tanggal = Carbon::parse($cuti->tanggal_mulai);

            while ($tanggal->lte($cuti->tanggal_selesai)) {

                Absensi::updateOrCreate([
                    'karyawan_id' => $karyawan->id,
                    'tanggal' => $tanggal->toDateString(),
                ], [
                    'status' => 'cuti',
                    // 'target_role' => 'karyawan',
                ]);

                $tanggal->addDay();
            }
        });

        return back()->with('success', 'Cuti berhasil disetujui');
    }

    public function reject(Request $request, $id)
    {
        $request->validate([
            'catatan_admin' => 'nullable|string'
        ]);

        $cuti = Cuti::findOrFail($id);

        $cuti->update([
            'status' => 'ditolak',
            'catatan_admin' => $request->catatan_admin
        ]);

        $pesan = "Pengajuan cuti Anda ditolak.";

        if (!empty($cuti->catatan_admin)) {
            $pesan .= "\n\nCatatan admin:\n" . $cuti->catatan_admin;
        } else {
            $pesan .= "\n\nSilakan hubungi HR untuk informasi lebih lanjut.";
        }

        Notifikasi::create([
            'user_id' => $cuti->karyawan->user->id,
            'judul'   => 'Cuti Ditolak',
            'pesan'   => $pesan,
            'type'    => 'cuti',
            'target_role' => 'karyawan'
        ]);


        return back()->with('success', 'Pengajuan cuti berhasil ditolak');
    }


    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
